# frozen_string_literal: true

require 'tilt'

def get_template(name, extension: 'slim')
  @templates ||= {}
  @templates[name] ||= Tilt.new(File.join(Indicina::TEMPLATE_PATH, "#{name}.#{extension}"), pretty: true)
end

def slim(template, scope, to)
  content = get_template(:layout).render(scope, {}) { get_template(template).render(scope, {}) }
  open(File.join(Indicina::OUTPUT_PATH, to), 'w') { |f| f.puts content }
end

def sass(template, scope, to)
  content = get_template(template, extension: 'sass').render(scope, {})
  open(File.join(Indicina::OUTPUT_PATH, to), 'w') { |f| f.puts content }
end
