# frozen_string_literal: true

ROM::SQL.migration do
  change do
    create_table :tests do
      column :id, String, null: false, unique: true, primary_key: true
      column :url, String, size: 2048
      column :location, String
      column :browser, String
      column :bandwidth_down, Integer
      column :bandwidth_up, Integer
      column :latency, Integer
      column :completed_at, Time

      column :video_url, String, size: 2048
      column :json_url, String, size: 2048

      column :has_video, TrueClass, default: false
      column :parse_complete, TrueClass, default: false
    end
  end
end
