# frozen_string_literal: true

ROM::SQL.migration do
  change do
    create_table :runs do
      primary_key :id
      unique [:test_id, :run]

      foreign_key :test_id, :tests, deferrable: true, type: String

      column :ran_at, Time, null: false
      column :run, Integer, null: false

      column :url, String, size: 2048, null: false
      column :location, String, null: false

      # Timings
      column :first_byte, Integer, null: false # 100
      column :dom_loading, Integer, null: false # 165
      column :title_time, Integer, null: false # 409
      column :first_paint, Integer, null: false # 745
      column :render, Integer, null: false # 810
      column :dom_interactive, Integer, null: false # 1773
      column :load_time, Integer, null: false # 8629
      column :fully_loaded, Integer, null: false # 117470
      column :last_visual_change, Integer, null: false # 119914

      # Stats
      column :dom_elements, Integer, null: false
      column :bytes_out, Integer, null: false
      column :bytes_in, Integer, null: false
      column :connections, Integer, null: false
      column :requests, Integer, null: false
      column :responses_200, Integer, null: false
      column :responses_404, Integer, null: false
      column :responses_other, Integer, null: false
      column :domain_names, Integer, null: false
    end
  end
end
