package twitch.instrumentorum

import jetbrains.buildServer.configs.kotlin.v2018_2.ParameterDisplay
import jetbrains.buildServer.configs.kotlin.v2018_2.ParametrizedWithType
import jetbrains.buildServer.configs.kotlin.v2018_2.TeamCityDsl

@TeamCityDsl
@Suppress("LongParameterList")
interface ParameterSupport {
    val params: ParametrizedWithType

    fun checkboxParam(
        name: String,
        value: String,
        label: String = "",
        description: String = "",
        display: ParameterDisplay = ParameterDisplay.HIDDEN,
        readOnly: Boolean = false,
        checked: String? = null,
        unchecked: String? = null
    ) = params.checkbox(name, value, label, description, display, readOnly, checked, unchecked)

    fun textParam(
        name: String,
        value: String,
        label: String = "",
        description: String = "",
        display: ParameterDisplay = ParameterDisplay.HIDDEN,
        readOnly: Boolean = false,
        allowEmpty: Boolean
    ) = params.text(name, value, label, description, display, readOnly, allowEmpty)

    fun textParam(
        name: String,
        value: String,
        label: String = "",
        description: String = "",
        display: ParameterDisplay = ParameterDisplay.HIDDEN,
        readOnly: Boolean = false,
        regex: String = "",
        validationMessage: String = ""
    ) = params.text(name, value, label, description, display, readOnly, regex, validationMessage)

    fun passwordParam(
        name: String,
        value: String,
        label: String = "",
        description: String = "",
        display: ParameterDisplay = ParameterDisplay.HIDDEN,
        readOnly: Boolean = false
    ) = params.password(name, value, label, description, display, readOnly)

    fun selectParam(
        name: String,
        value: String,
        label: String = "",
        description: String = "",
        display: ParameterDisplay = ParameterDisplay.HIDDEN,
        readOnly: Boolean = false,
        allowMultiple: Boolean = false,
        valueSeparator: String = ",",
        options: List<Any> = listOf()
    ) = params.select(name, value, label, description, display, readOnly, allowMultiple, valueSeparator, options)
}
