package twitch.instrumentorum.enums

import twitch.instrumentorum.ParameterSupport

enum class ProjectSetting(val key: String, private val label: String, private val description: String) {
    EcrAccountId("ecr.account.id", "ECR Account Id", "The account to use for ECR Repositories"),
    EcrAssumeRole("ecr.account.role", "ECR Assume Role", "The role to assume when accessing ECR"),
    EcrRepository("ecr.repo", "ECR Repository", "The name used the ECR Repository");

    fun addParameter(target: ParameterSupport, value: String) =
        target.textParam(key, value, label, description, readOnly = true)
}
