package twitch.instrumentorum.exceptions

class AmbiguousBuildReference(message: String) : Exception(message)
class BuildNotFound(message: String) : Exception(message)
class DockerArgumentException(message: String) : Exception(message)
class DuplicateRegion(property: String, region: String) : Exception("Duplicate region '$region' used in '$property'")
class MissingAsset(assetName: String) : Exception("Unable to locate asset named: $assetName")
class ParameterNotFound(message: String) : Exception(message)
