package twitch.instrumentorum.helpers

import twitch.instrumentorum.InstrumProject
import twitch.instrumentorum.exceptions.MissingAsset
import java.io.File

fun assetText(name: String, allowOverride: Boolean = true, override: File = File(name)): String {
    if (allowOverride && override.exists()) {
        return override.readText()
    }

    return InstrumProject::class.java.classLoader.getResource(name)?.readText()
        ?: throw MissingAsset(name)
}
