package twitch.instrumentorum.helpers

import twitch.instrumentorum.InstrumProject

internal val idValidationRegex = Regex("[^A-Za-z0-9_]")

fun nameToId(vararg names: String) =
    idValidationRegex.replace(names.joinToString(""), "")

fun nameToId(name: String, parentProject: InstrumProject?): String {
    val parts = mutableListOf<String?>(name)
    var parent = parentProject

    while (parent != null) {
        parts.add(0, parent.idNamespace)
        parent = parent.parent
    }

    return idValidationRegex.replace(parts.filterNotNull().joinToString(""), "")
}
