package twitch.instrumentorum.project.build.features

import jetbrains.buildServer.configs.kotlin.v2018_2.BuildFeatures
import jetbrains.buildServer.configs.kotlin.v2018_2.BuildType
import jetbrains.buildServer.configs.kotlin.v2018_2.TeamCityDsl
import jetbrains.buildServer.configs.kotlin.v2018_2.buildFeatures.CommitStatusPublisher
import jetbrains.buildServer.configs.kotlin.v2018_2.vcs.GitVcsRoot

@TeamCityDsl
fun BuildFeatures.githubStatusPublisher(vcsRoot: GitVcsRoot, init: CommitStatusPublisher.() -> Unit = {}) {
    val result = CommitStatusPublisher {
        vcsRootExtId = "${vcsRoot.id}"
        publisher = github {
            githubUrl = "https://git.xarth.tv/api/v3"
            authType = personalToken {
                token = "credentialsJSON:06c8cbc2-4163-4856-a7b1-e768875cd57d"
            }
        }

        init()
    }

    feature(result)
}

@TeamCityDsl
fun BuildType.githubStatusPublisher(vcsRoot: GitVcsRoot, init: CommitStatusPublisher.() -> Unit) =
    features.githubStatusPublisher(vcsRoot, init)
