package twitch.instrumentorum.project.builds

import jetbrains.buildServer.configs.kotlin.v2018_2.TeamCityDsl
import twitch.instrumentorum.BuildGroup
import twitch.instrumentorum.InstrumBuild
import twitch.instrumentorum.InstrumProject
import twitch.instrumentorum.project.steps.gitVersionNumber

@TeamCityDsl
fun BuildGroup.initializeBuildChain(init: InstrumBuild.() -> Unit = {}): InstrumBuild {
    return build("Initialize Build Chain") {
        textParam("git.version", "", "Git Version", "The version as determined by git tag inspection.")
        textParam("git.commit.short", "", "Git Short Hash", "The short hash of the commit inspected.")
        propagateParams("git.version", "git.commit.short")

        steps.gitVersionNumber()

        init()
    }
}

@TeamCityDsl
fun InstrumProject.initializeBuildChain(init: InstrumBuild.() -> Unit = {}): InstrumBuild =
    BuildGroup(this, false).initializeBuildChain(init)
