package twitch.instrumentorum.project.steps

import jetbrains.buildServer.configs.kotlin.v2018_2.BuildSteps
import jetbrains.buildServer.configs.kotlin.v2018_2.BuildType
import jetbrains.buildServer.configs.kotlin.v2018_2.TeamCityDsl
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.dockerCommand
import twitch.instrumentorum.exceptions.DockerArgumentException

@TeamCityDsl
@Suppress("LongParameterList")
fun BuildSteps.dockerBuild(
    tags: Collection<String>,
    dockerArgs: Collection<String>,
    path: String = "Dockerfile",
    target: String? = null,
    cacheFrom: String? = null,
    contextDir: String? = null,
    dockerfileContent: String = ""
) {
    var args = dockerArgs.joinToString(" ")

    if (target != null) {
        if (args.contains("--target")) {
            throw DockerArgumentException("You may not use the target parameter and set a '--target' dockerArg")
        }

        args = "$args --target $target"
    }

    if (cacheFrom != null) {
        if (args.contains("--cache-from")) {
            throw DockerArgumentException("You may not use the cacheFrom parameter and set a '--cache-from' dockerArg")
        }

        args = "$args --cache-from $cacheFrom"
    }

    if (!args.contains("--pull")) {
        args = "$args --pull"
    }

    dockerCommand {
        name = "Build Docker Image"

        commandType = build {
            if (dockerfileContent.isBlank()) {
                source = path {
                    this.path = path
                }
            } else {
                source = content {
                    this.content = dockerfileContent
                }
            }
            this.contextDir = contextDir
            namesAndTags = tags.joinToString("\n")
            commandArgs = args
        }
    }
}

@TeamCityDsl
@Suppress("LongParameterList")
fun BuildSteps.dockerBuild(
    tags: Collection<String>,
    vararg dockerArgs: String,
    path: String = "Dockerfile",
    target: String? = null,
    cacheFrom: String? = null,
    contextDir: String? = null,
    dockerfileContent: String = ""
) = dockerBuild(tags, dockerArgs.toList(), path, target, cacheFrom, contextDir, dockerfileContent)

@TeamCityDsl
@Suppress("LongParameterList")
fun BuildSteps.dockerBuild(
    tags: String,
    vararg dockerArgs: String,
    path: String = "Dockerfile",
    target: String? = null,
    cacheFrom: String? = null,
    contextDir: String? = null,
    dockerfileContent: String = ""
) = dockerBuild(listOf(tags), dockerArgs.toList(), path, target, cacheFrom, contextDir, dockerfileContent)

@TeamCityDsl
@Suppress("LongParameterList")
fun BuildType.dockerBuild(
    tags: Collection<String>,
    vararg dockerArgs: String,
    path: String = "Dockerfile",
    target: String? = null,
    cacheFrom: String? = null,
    contextDir: String? = null,
    dockerfileContent: String = ""
) = steps.dockerBuild(tags, dockerArgs.toList(), path, target, cacheFrom, contextDir, dockerfileContent)

@TeamCityDsl
@Suppress("LongParameterList")
fun BuildType.dockerBuild(
    tags: String,
    vararg dockerArgs: String,
    path: String = "Dockerfile",
    target: String? = null,
    cacheFrom: String? = null,
    contextDir: String? = null,
    dockerfileContent: String = ""
) = steps.dockerBuild(listOf(tags), dockerArgs.toList(), path, target, cacheFrom, contextDir, dockerfileContent)
