package twitch.instrumentorum.project.steps

import jetbrains.buildServer.configs.kotlin.v2018_2.BuildSteps
import jetbrains.buildServer.configs.kotlin.v2018_2.BuildType
import jetbrains.buildServer.configs.kotlin.v2018_2.TeamCityDsl
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.dockerCommand

@TeamCityDsl
fun BuildSteps.dockerPull(image: String, dockerArgs: List<String>, workingDir: String? = null) {
    val args = "$image ${dockerArgs.joinToString(" ")}".trim()

    dockerCommand {
        name = "Pull Docker Image"

        commandType = other {
            subCommand = "pull"
            commandArgs = args
            this.workingDir = workingDir
        }
    }
}

@TeamCityDsl
fun BuildSteps.dockerPull(image: String, vararg dockerArgs: String, workingDir: String? = null) =
    dockerPull(image, dockerArgs.toList(), workingDir)

@TeamCityDsl
fun BuildType.dockerPull(image: String, vararg dockerArgs: String, workingDir: String? = null) =
    steps.dockerPull(image, dockerArgs.toList(), workingDir = workingDir)
