package twitch.instrumentorum.project.steps

import jetbrains.buildServer.configs.kotlin.v2018_2.BuildSteps
import jetbrains.buildServer.configs.kotlin.v2018_2.BuildType
import jetbrains.buildServer.configs.kotlin.v2018_2.TeamCityDsl
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.dockerCommand

@TeamCityDsl
fun BuildSteps.dockerPush(tags: String, cleanupImage: Boolean = true) {
    dockerCommand {
        name = "Push Docker Image"

        commandType = push {
            namesAndTags = tags
            removeImageAfterPush = cleanupImage
        }
    }
}

@TeamCityDsl
fun BuildType.dockerPush(tags: String, cleanupImage: Boolean = true) =
    steps.dockerPush(tags, cleanupImage)
