package twitch.instrumentorum.project.steps

import jetbrains.buildServer.configs.kotlin.v2018_2.BuildSteps
import jetbrains.buildServer.configs.kotlin.v2018_2.BuildType
import jetbrains.buildServer.configs.kotlin.v2018_2.TeamCityDsl
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.script
import twitch.instrumentorum.helpers.assetText

@TeamCityDsl
fun BuildSteps.gitVersionNumber() {
    script {
        name = "Discover Version Number"
        scriptContent = assetText("scripts/git_version_number.rb")
    }
}

@TeamCityDsl
fun BuildType.gitVersionNumber() =
    steps.gitVersionNumber()
