package twitch.instrumentorum.project.steps

import jetbrains.buildServer.configs.kotlin.v2018_2.BuildSteps
import jetbrains.buildServer.configs.kotlin.v2018_2.BuildType
import jetbrains.buildServer.configs.kotlin.v2018_2.TeamCityDsl
import jetbrains.buildServer.configs.kotlin.v2018_2.buildSteps.script
import twitch.instrumentorum.enums.AWSRegion
import twitch.instrumentorum.helpers.assetText

@TeamCityDsl
fun BuildSteps.verifyECRRepository(repositoryName: String, region: AWSRegion = AWSRegion.PDX) {
    script {
        name = "Verify '$repositoryName' ECR Repo"
        scriptContent = assetText("scripts/verify_ecr_repository.sh")
            .replace("\$AWS_REGION", region.region)
            .replace("\$REPO_NAME", repositoryName)
    }
}

@TeamCityDsl
fun BuildType.verifyECRRepository(repositoryName: String, region: AWSRegion = AWSRegion.PDX) =
    steps.verifyECRRepository(repositoryName, region)
