# frozen_string_literal: true

lib = File.expand_path('../lib', __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)

require 'litany/version'

Gem::Specification.new do |spec| # rubocop:disable Metrics/BlockLength
  # protect against an accidental release
  raise 'RubyGems 2.0 or newer is required to protect against public gem pushes.' unless spec.respond_to?(:metadata)
  spec.metadata['allowed_push_host'] = 'https://gem.pkgs.xarth.tv'

  # configure the gem
  spec.name          = 'litany'
  spec.version       = Litany::VERSION
  spec.authors       = ['Bryan McLemore', 'Trey Briggs', 'Thomas Hanson']
  spec.email         = ['mclemore@justin.tv']

  spec.summary       = 'Provides a declarative DSL to provision AWS infrastructure.'
  spec.description   = 'Litany provides a declarative DSL to define your AWS infrastructure.  This DSL is combined with years of operational expertise to help bake in best practices with minimal effort.  Ultimately CloudFormation templates are generated from the DSL and uploaded to AWS.'
  spec.homepage      = 'https://git-aws.internal.justin.tv/CPE-Ops/litany'
  spec.license       = 'Nonstandard' # All Rights Reserved

  spec.files         = `git ls-files -z`.split("\x0").reject { |f| f.match '^(bin|lambdas|test)' }
  spec.bindir        = 'exe'
  spec.executables   = ['lit']
  spec.require_paths = ['lib']

  spec.add_dependency 'activesupport', '~> 5.1'
  spec.add_dependency 'arcana', '~> 0.9'
  spec.add_dependency 'aws-sdk-cloudformation', '~> 1.5'
  spec.add_dependency 'aws-sdk-iam', '~> 1.4'
  # spec.add_dependency 'aws-sdk-s3', '~> 1.13'
  spec.add_dependency 'clamp', '~> 1.2'
  spec.add_dependency 'deep_merge', '~> 1.1'
  spec.add_dependency 'hashie', '~> 3.5'
  spec.add_dependency 'highline', '~> 1.7.10'
  spec.add_dependency 'json', '~> 2.0'
  spec.add_dependency 'neatjson', '~> 0.8'
  spec.add_dependency 'netaddr', '~> 1.5'
  spec.add_dependency 'rainbow', '~> 3.0'
  spec.add_dependency 'tilt', '~> 2.0'

  spec.add_development_dependency 'awesome_print', '~> 1.7'
  spec.add_development_dependency 'bundler', '~> 1.14'
  spec.add_development_dependency 'geminabox-release', '~> 1.2'
  spec.add_development_dependency 'minitest', '~> 5.0'
  spec.add_development_dependency 'pry', '~> 0.10'
  spec.add_development_dependency 'rake', '~> 12.3'
  spec.add_development_dependency 'rubocop', '~> 0.89.0'
  spec.add_development_dependency 'simplecov', '~> 0.14'
  spec.add_development_dependency 'yard', ' ~> 0.9.20'
end
