# frozen_string_literal: true

# External libraries
require 'deep_merge'
require 'digest'
require 'hashie'
require 'json'
require 'logger'
require 'neatjson'
require 'netaddr'
require 'rainbow'
require 'set'
require 'tilt'

# It's all about that base...
require 'litany/version'
require 'litany/patches'

require 'litany/base/abbreviations'
require 'litany/base/constants'
require 'litany/base/delegator'
require 'litany/base/indicium'
require 'litany/base/log_formatter'
require 'litany/base/settings'

require 'litany/base/base'

# Pieces to the puzzle
require 'litany/mixins'
require 'litany/resource'
require 'litany/resource_output'
require 'litany/resource_reference'

# Stubs to allow for circular references
require 'litany/resources/_stubs'
require 'litany/meta_resources/_stubs'

# Resources
require 'litany/resources/application_load_balancer'
require 'litany/resources/application_load_balancer_listener'
require 'litany/resources/application_load_balancer_listener_rule'
require 'litany/resources/application_load_balancer_target_group'
require 'litany/resources/auto_scaling_group'
require 'litany/resources/auto_scaling_launch_configuration'
require 'litany/resources/beanstalk_application'
require 'litany/resources/beanstalk_environment'
require 'litany/resources/certificate'
require 'litany/resources/cloudfront'
require 'litany/resources/cloudwatch_alarm'
require 'litany/resources/cloudwatch_log_group'
require 'litany/resources/cloudwatch_log_metric_filter'
require 'litany/resources/dns_alias'
require 'litany/resources/dns_health_check'
require 'litany/resources/dns_record'
require 'litany/resources/dns_zone'
require 'litany/resources/ec2_eip'
require 'litany/resources/ecr_repository'
require 'litany/resources/ecs_cluster'
require 'litany/resources/ecs_service'
require 'litany/resources/ecs_task_definition'
require 'litany/resources/efs_filesystem'
require 'litany/resources/efs_mount_target'
require 'litany/resources/elasticache_subnet_group'
require 'litany/resources/elasticache'
require 'litany/resources/elastic_load_balancer'
require 'litany/resources/elasticsearch'
require 'litany/resources/events_rule'
require 'litany/resources/iam_role'
require 'litany/resources/instance'
require 'litany/resources/instance_profile'
require 'litany/resources/instance_profile_role'
require 'litany/resources/internet_gateway'
require 'litany/resources/kinesis_stream'
require 'litany/resources/kms_alias'
require 'litany/resources/kms_key'
require 'litany/resources/lambda_function'
require 'litany/resources/lambda_permission'
require 'litany/resources/network_load_balancer'
require 'litany/resources/network_load_balancer_listener'
require 'litany/resources/network_load_balancer_target_group'
require 'litany/resources/rds_cluster'
require 'litany/resources/rds_cluster_parameter_group'
require 'litany/resources/rds_instance'
require 'litany/resources/rds_instance_option_group'
require 'litany/resources/rds_instance_parameter_group'
require 'litany/resources/rds_subnet_group'
require 'litany/resources/redshift_cluster'
require 'litany/resources/redshift_parameter_group'
require 'litany/resources/redshift_subnet_group'
require 'litany/resources/route'
require 'litany/resources/route_table'
require 'litany/resources/s3_bucket'
require 'litany/resources/s3_bucket_policy'
require 'litany/resources/secrets_manager_attachment'
require 'litany/resources/secrets_manager_secret'
require 'litany/resources/security_group'
require 'litany/resources/security_group_ingress'
require 'litany/resources/sns_subscription'
require 'litany/resources/sns_topic'
require 'litany/resources/sqs_queue'
require 'litany/resources/sqs_queue_policy'
require 'litany/resources/subnet'
require 'litany/resources/subnet_route_table_association'
require 'litany/resources/volume'
require 'litany/resources/vpc'
require 'litany/resources/vpc_endpoint'
require 'litany/resources/vpc_endpoint_service'
require 'litany/resources/vpc_endpoint_service_permissions'
require 'litany/resources/vpc_internet_gateway_attachment'
require 'litany/resources/vpc_peering_connection'
require 'litany/resources/vpc_vpn_gateway_attachment'
require 'litany/resources/vpn_gateway'
require 'litany/resources/vpn_gateway_route_propagation'

# Meta Resources
require 'litany/meta_resources/acm_certificates'
require 'litany/meta_resources/alarms'
require 'litany/meta_resources/application_load_balancer_fixed_response'
require 'litany/meta_resources/auto_scaling_volume'
require 'litany/meta_resources/base_service'
require 'litany/meta_resources/beanstalk'
require 'litany/meta_resources/beanstalk_option_setting'
require 'litany/meta_resources/certificate_domain_name'
require 'litany/meta_resources/cloudfront_cache_behavior'
require 'litany/meta_resources/dns_zone_reference'
require 'litany/meta_resources/ecr'
require 'litany/meta_resources/ecs'
require 'litany/meta_resources/ecs_scheduled_task'
require 'litany/meta_resources/ecs_services'
require 'litany/meta_resources/elastic_load_balancer_listener'
require 'litany/meta_resources/environment'
require 'litany/meta_resources/iam_permissions'
require 'litany/meta_resources/iam_policy_document'
require 'litany/meta_resources/iam_policy_statement'
require 'litany/meta_resources/image'
require 'litany/meta_resources/instance_group'
require 'litany/meta_resources/lambda_service'
require 'litany/meta_resources/redirects'
require 'litany/meta_resources/redshift'
require 'litany/meta_resources/rds'
require 'litany/meta_resources/rds_aurora'
require 'litany/meta_resources/rds_instance_option_group_option'
require 'litany/meta_resources/rds_mssql'
require 'litany/meta_resources/rds_mysql'
require 'litany/meta_resources/s3_cors_configuration'
require 'litany/meta_resources/service'
require 'litany/meta_resources/sns'
require 'litany/meta_resources/userdata'
require 'litany/meta_resources/vpc_reference'

# The ties that bind
require 'litany/plugins'
require 'litany/project'

# Load extra subsytems
require 'litany/subsystems/arcana'
