# frozen_string_literal: true

require 'active_support/inflector'

ActiveSupport::Inflector.inflections do |inflect|
  inflect.irregular 'alarms', 'alarm_collection'
  inflect.irregular 'ecs', 'ecs_clusters'
  inflect.irregular 'sns', 'sns_topics'
  inflect.irregular 'efs', 'efs_filesystems'
  inflect.irregular 'ecs_services', 'ecs_service_group'
end

module Litany

  ABBREVIATIONS = [
    'acm', # Amazon Certificate Manager
    # 'alb', # Application Load Balancer
    'cdn', # Content Delivery Network
    'cpe', # Client Platform Engineering
    'cpu', # Computer Processor Unit
    'csi', # Client Systems Infrastructure
    'db',  # Database
    'dns', # Domain Name System
    'ebs', # Elastic Block Storage
    'ec',  # Elasticache
    'ecr', # Elastic Container Repo
    'ecs', # Elastic Container Service
    'efs', # Elastic File System
    'iam', # Identity & Access Management
    'io',
    'kms', # Key Management System
    # 'sg',  # Security Group
    'sns', # Simple Notification Service
    'sqs', # Simple Queue Service
    'svc', # Service
    'rds', # Relation Database Service
    'vpc', # Virtual Private Cloud
    'vpn', # Virtual Private Network
    'wtf'  # Wow That's Fast
  ]

end
