# frozen_string_literal: true

module Litany
  class Base
    extend Delegator

    class << self
      def logger
        @logger ||= Logger.new(settings.log_target).tap do |logger|
          logger.level = Logger.const_get(settings.log_level.upcase.to_sym)
          logger.progname = 'Litany'
          logger.formatter = LogFormatter

          Hashie.logger = logger
        end
      end

      def settings
        @@settings ||= Settings.new
      end
    end

    delegate_to proc { Base.logger }, :debug, :info, :warn, :error, :fatal, :unknown
    passthrough :logger, :debug, :info, :warn, :error, :fatal, :unknown

    settings.log_level = :info
    settings.log_target = STDOUT
  end

  extend Delegator
  delegate_to proc { Base.logger }, :debug, :info, :warn, :error, :fatal, :unknown
  delegate_to proc { Base.settings }, :disable, :enable, :fetch, :set, :set?, private: false
end
