# frozen_string_literal: true

module Litany
  # A module mixin to create an interface mixin.  Generally for IoC delegates.
  # @abstract
  module Interface

    # Signifies that a concrete representation of this interface may optionally implement this method.
    # @param method [Symbol] the name of the method this is describing.
    # @param default: [Object] the default value returned if the concrete class doesn't implement the method.
    #   If a proc is provided, it's return value is used as the default.
    # @return [void]
    def may_implement(method, default: nil)
      # @todo do something useful here
    end
  end
end