# frozen_string_literal: true

require 'litany'

require 'litany/cli/base'
require 'litany/cli/compile'
require 'litany/cli/config'
require 'litany/cli/console'
require 'litany/cli/init'
require 'litany/cli/upload'
require 'litany/cli/verify'

module Litany
  module CLI
    # Root CLI command to hang subcommands on.
    # @api internal
    class Runner < CLI::Base

      subcommand 'init', 'Initializes a new project workspace.', Init
      subcommand 'compile', 'Compiles the current Litany workspace.', Compile
      subcommand 'config', 'Allows for litany configuration', Config
      subcommand 'console', 'Starts a debug console within the context of the current project if applicable.', Console
      subcommand 'upload', 'Uploads stacks to AWS starts the application of the new CFN stacks.', Upload
      subcommand 'verify', 'Creates and parses a change set for one or more stacks.', Verify

      option '--version', :flag, 'Shows the version.' do
        puts Litany::VERSION
        exit(0)
      end
    end
  end
end
