# frozen_string_literal: true

require 'litany/cli/base'
require 'litany/cli/config_get'
require 'litany/cli/config_set'
require 'litany/project/project_workspace'

module Litany
  module CLI
    # Provides configuration CLI methods
    class Config < Litany::CLI::Base

      subcommand 'get', 'Prints the value of a given workspace option.', ConfigGet
      subcommand 'set', 'Sets the value of a given workspace option.', ConfigSet
    end
  end
end
