# frozen_string_literal: true

require 'litany/cli/base'
require 'litany/project/project_workspace'
require 'litany/project/project_workspace_delegate'

module Litany
  module CLI
    # Abstract base class for CLI commands that work with workspace options
    # @abstract
    class ConfigBase < Base
      include ProjectWorkspaceDelegate

      option ['-d', '--directory'], 'PATH','project workspace directory', default: Dir.pwd, &proc { |dir| File.expand_path(dir) }
      option ['-k', '--key'], 'KEY', 'the name of the option you are referencing', required: true
      option ['-l', '--layer'], 'LAYER', 'the effective configuration layer to reference', default: :project

      # Returns the workspace instance tied to the directory option.  Uses `self` as the workspace delegate.
      private def workspace
        @workspace ||= ProjectWorkspace.new(directory: directory, delegate: self)
      end
    end
  end
end
