# frozen_string_literal: true

require 'litany/cli/config_base'
require 'litany/project/project_workspace'

module Litany
  module CLI
    # Provides configuration CLI methods
    class ConfigSet < Litany::CLI::ConfigBase

      def execute
        option = workspace.workspace_option(key)

        value = ask "What value would you like to set for #{key}?", default: option.default
        workspace.set_option(key, value, layer: layer)
      end
    end
  end
end
