# frozen_string_literal: true

require 'litany/cli/project_base'

module Litany
  module CLI
    # Compiles the current Litany workspace
    class Verify < Litany::CLI::ProjectBase

      option ['-S', '--stack'], 'STACK NAME', 'If provided the upload operation will only target the stack name provided.', multivalued: true, default: []

      def execute
        matching_stacks.each { |project, stack_name| submit_change_set(project, stack_name, auto_delete: true) }
      end
    end
  end
end
