# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class ApplicationLoadBalancerFixedResponse < MetaResource
    property :content_type, 'text/html', ['text/plain', 'text/css', 'text/html', 'application/javascript', 'application/json']
    property :body, nil, [String]
    property :status_code, nil, [200..299, 400..499, 500..599]

    def to_json(*args)
      {
        ContentType: content_type,
        MessageBody: body,
        StatusCode: status_code
      }.to_json(*args)
    end
  end
end
