# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class BaseService < MetaResource
    include ServiceRoot
    include Stack
    include Taggable

    child_resource InstanceProfile, :instance_profile, automatic: :on_access

    property :instance_type, nil, [nil, String]
    property :key_pair, nil, [nil, String, Symbol], inherited: true

    resource_collection ApplicationLoadBalancer, :alb, required: false
    resource_collection Certificate, :certificate, required: false
    resource_collection CloudWatchAlarm, :cloudwatch_alarm, required: false
    resource_collection DNSAlias, :dns_alias, required: false
    resource_collection DNSRecord, :dns_record, required: false
    resource_collection ECRRepository, :ecr_repository, required: false
    resource_collection ElasticFileSystem, :efs, required: false
    resource_collection ElasticLoadBalancer, :elb, required: false
    resource_collection ElasticsearchDomain, :elasticsearch, required: false
    resource_collection IAMRole, :iam_role, required: false
    resource_collection Instance, :instance, required: false
    resource_collection InstanceGroup, :instance_group, required: false
    resource_collection KinesisStream, :kinesis_stream, required: false
    resource_collection KMSKey, :kms_key, required: false
    resource_collection LambdaFunction, :lambda_function, required: false
    resource_collection RDSAurora, :rds_aurora, required: false
    resource_collection RDSMysql, :rds_mysql, required: false
    resource_collection RDSMssql, :rds_mssql, required: false
    resource_collection S3Bucket, :bucket, required: false
    resource_collection SecurityGroup, :security_group, required: false
    resource_collection SNSTopic, :topic, required: false
    resource_collection SQSQueue, :queue, required: false

    resource_reference Image, :image, required: false
    resource_reference VPC, :vpc

    resource_references Environment, :only_in, required: false

    def default_tags
      {
        LitanyServiceName: self.name
      }
    end

    def finalize_resource
      instance_profile if set_instances? || set_instance_groups?
    end
  end
end
