# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class BeanstalkOptionSetting < MetaResource

    property :namespace, nil, String
    property :option, nil, String
    property :resource, nil, [String, nil]
    property :value, nil, [String, Hash, ResourceReference] do |value|
      value.is_a?(Hash) || value.is_a?(ResourceReference) ? value : value.to_s
    end

    def to_json(*args)
      props = {
        Namespace: namespace,
        OptionName: option,
        Value: value
      }

      props[:ResourceName] = resource if set_resource?

      props.to_json(*args)
    end
  end
end
