# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class CertificateDomainName < MetaResource
    parent_resource :certificate

    property :domain, nil, [String, Symbol] do |value|
      raise 'Domain name is limited to a maximum of 253 characters.' unless value.size <= 253
      raise "Domain name must match `/#{domain_regex}/`" unless domain_regex.match(value)

      value.to_s
    end

    property :validation_domain, nil, [String, Symbol, nil] do |value|
      raise 'Domain name is limited to a maximum of 253 characters.' unless value.size <= 253
      raise "Domain name must match `/#{domain_regex}/`" unless domain_regex.match(value)

      value.to_s
    end

    def domain_regex
      /^(\*\.)?(((?!-)[A-Za-z0-9-]{0,62}[A-Za-z0-9])\.)+((?!-)[A-Za-z0-9-]{1,62}[A-Za-z0-9])$/
    end
  end
end
