# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class ECSServices < MetaResource
    include Stack

    resource_collection ECSService, :service, required: false
    resource_collection ECSScheduledTask, :scheduled_task, required: false

    resource_collection KinesisStream, :kinesis_stream, required: false

    resource_collection SQSQueue, :queue, required: false
    resource_collection SNSTopic, :topic, required: false

    resource_reference ECS, :cluster, inherited: true
    resource_references Environment, :only_in, required: false

    def vpc
      cluster.vpc
    end

    def set_vpc?
      set_cluster? && cluster.set_vpc?
    end

  end
end
