# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class ElasticLoadBalancerListener < MetaResource
    parent_resource :elb

    property :instance_port, 80, [1..65536], inherited: true
    property :instance_protocol, :http, [:http, :https, :tcp, :ssl], inherited: true
    property :listener_port, 80, [1..65536], inherited: true
    property :listener_protocol, :http, [:http, :https, :tcp, :ssl], inherited: true
    resource_reference Certificate, :certificate, required: false

    def to_json(*args)
      # TODO: PolicyNames

      props = {
        InstancePort: instance_port,
        InstanceProtocol: instance_protocol,
        LoadBalancerPort: listener_port,
        Protocol: listener_protocol
      }

      props[:SSLCertificateId] = ref(certificate) if set_certificate?

      props.to_json(*args)
    end
  end
end