# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class Environment < MetaResource

    flag :default, false

    property :region, nil, [Symbol, String] do |value|
      value.to_s.tr('_', '-').to_sym
    end

    resource_reference Route53Zone, :dns_zone, required: false
    resource_reference DNSZoneReference, :dns_zone_reference, required: false

    validator :zone_config do
      raise 'You may not set both `dns_zone` and `dns_zone_reference`.' if set_dns_zone? && set_dns_zone_reference?
    end

    def pretty_region
      parts = region.to_s.split('-')
      "#{parts[0].upcase}#{parts[1].capitalize}#{parts[2]}"
    end

    def short_region
      parts = region.to_s.split('-')
      "#{parts[0]}#{short_compass(parts[1])}#{parts[2]}"
    end

    def short_compass(direction)
      case direction
      when 'west', 'east', 'north', 'south'
        direction[0]
      else
        direction[0..1]
      end
    end
  end
end
