# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class IAMPolicyDocument < MetaResource

    resource_collection IAMPolicyStatement, :statement

    class << self
      def child_resource_name(parent, base)
        parent.resource_name.snake_case
      end
    end

    def next_statement(&block)
      @next_statement_id ||= 0
      statement format("#{name}_Statement%03d", @next_statement_id += 1).to_sym, &block
    end

    def to_json(*args)
      {
        Version: '2012-10-17',
        Statement: statements.collect(&:statement)
      }.to_json(*args)
    end
  end
end
