# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class Image < MetaResource
    parent_resource :project

    child_resource UserData, :userdata, automatic: false

    property :ami, nil, [String]

    def userdata_template(template)
      userdata { template template }
    end
  end
end
