# frozen_string_literal: true

require 'litany/base/indicium'
require 'litany/mixins'
require 'litany/resource'

module Litany
  class RDSInstanceOptionGroupOption < MetaResource

    property :option, nil, String
    property :port, nil, [nil, 1..65_535]

    resource_references SecurityGroup, :security_group, required: false

    def setting(setting, value)
      @settings ||= Indicium.new
      raise "Setting `#{setting}` is already set to #{@settings[setting]}.  Attempted to reassign to #{value}." if @settings.include?(setting)
      @settings[setting] = {Name: setting, Value: value}
    end

    def to_json(*args)
      props = {
        OptionName: option
      }

      props[:OptionSettings] = @settings.values unless @settings.nil?
      props[:Port] = port if set_port?
      props[:VpcSecurityGroupMemberships] = ref(security_groups) if set_security_groups?

      props.to_json(*args)
    end
  end
end
