# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'

module Litany
  class S3CorsConfiguration < MetaResource

    property :max_age, nil, [nil, Integer]
    property :id, nil, [nil, String]

    property_collection :exposed_header, [], [String], required: false
    property_collection :header, [], [String], required: false
    property_collection :method, [], [:get, :put, :post, :delete, :head]
    property_collection :origin, [], [String, Symbol]

    def to_json(*args)
      config = {
          AllowedMethods: methods.collect(&:upcase),
          AllowedOrigins: origins
      }

      config[:AllowedHeaders] = headers if set_headers?
      config[:ExposedHeaders] = exposed_headers if set_exposed_headers?

      config[:MaxAge] = max_age if set_max_age?
      config[:Id] = id if set_id?

      config.to_json(*args)
    end
  end
end
