# frozen_string_literal: true

module Litany
  # Include this into a resource to mark it as a service, used in calculation of service_id.
  module ServiceRoot
    # Simple DSL only available to service roots
    module ServiceRootDSL
      def service_name_pattern(suffix = nil)
        @service_name_suffix ||= suffix || '%s'
      end
    end

    class << self
      def included(target)
        target.extend(ServiceRootDSL)
      end
    end

    def chef_attributes
      @chef_attributes ||= Indicium.new { |h, k| h[k] = Indicium.new(&h.default_proc) }
    end

    def service?
      true
    end

    def service_name
      self.class.service_name_pattern % name
    end
  end
end
