# frozen_string_literal: true

module Litany
  # Adds the tag keyword, causes a resource to auto-tag it's Name
  module Taggable
    def compiled_tags
      resource_tree.collect { |resource| resource.taggable? ? resource.tags : {} }.reduce(:merge).values
    end

    def default_tags
      {}
    end

    def tag(key, value)
      tags[key.snake_case.to_sym] = { Key: key.pascal_case.to_sym, Value: value }
    end

    def taggable?
      true
    end

    def tags
      return @tags unless @tags.nil?

      # exempting default tags from running their key through pascal_case, this is a compatibility measure for 0.9
      # TODO: remove this exception for 1.0
      @tags = default_tags.map { |k, v| { k.snake_case.to_sym => { Key: k, Value: v } } }.reduce({}, :merge)
      @tags[:litany_type] = { Key: :LitanyType, Value: self.class.name.demodulize }

      @tags
    end

    def tag_key
      :Tags
    end
  end
end
