# frozen_string_literal: true

class Object
  def subclass_of?(superclass)
    respond_to?(:ancestors) ? ancestors.include?(superclass) : self.class.ancestors.include?(superclass)
  end

  def descendants
    descendants = []
    ObjectSpace.each_object(singleton_class) do |k|
      descendants.unshift k unless k == self
    end
    descendants
  end
end
