# frozen_string_literal: true

class Symbol

  def capitalize(*args, &block)
    to_s.capitalize(*args, &block).to_sym
  end

  def count(*args, &block)
    to_s.count(*args, &block)
  end

  def dash_case
    to_s.dash_case.to_sym
  end

  def camel_case
    to_s.camel_case.to_sym
  end

  def gsub(*args, &block)
    to_s.gsub(*args, &block).to_sym
  end

  def include?(*args)
    to_s.include?(*args)
  end

  def pascal_case
    to_s.pascal_case.to_sym
  end

  def snake_case
    to_s.snake_case.to_sym
  end

  def split(*args, &block)
    to_s.split(*args, &block).map(&:to_sym)
  end

  def tr(*args, &block)
    to_s.tr(*args, &block).to_sym
  end

  def pluralize(count = nil, locale = :en)
    to_s.pluralize(count, locale).to_sym
  end
end
