# frozen_string_literal: true

# Namespace module for all Litany classes and modules.
module Litany

  class << self
    # Loads any plugins that happen to be in this workspace.
    # @param workspace [ProjectWorkspace]
    def load_plugins(workspace)
      @loaded_plugins ||= []

      workspace.plugin_files.each do |path|
        @loaded_plugins << path if !@loaded_plugins.include?(path) && require(path)
      end
    end
  end

end
