# frozen_string_literal: true

require 'litany/base/interface'

module Litany
  # Abstract interface providing an IoC delegate for {ProjectWorkspace}.
  # @abstract
  module ProjectWorkspaceDelegate
    extend Interface

    # @!method use_non_empty_workspace?
    # Answers whether a project workspace should initialize in non-empty folder.
    # @return [Boolean] defaults to `false`.
    may_implement :use_non_empty_workspace?, default: false

    # @!method overwrite_existing_workspace?
    # Answers whether a project workspace should overwrite a pre-existing workspace.
    # @return [Boolean] defaults to `false`.
    may_implement :overwrite_existing_workspace?, default: false

    # @!method new_workspace_name
    # Responds with the name of the project.
    # @return [String] The name of the project.
    may_implement :new_workspace_name

    # @!method aws_profile
    # Responds with the name of the AWS profile. Return nil or an empty string if the workspace should not use this style of authentication.
    # @return [String] The name of the aws profile.  Must conform to `/^[a-z-]+$/`.
    may_implement :aws_profile

    # @!method allowed_stages
    # Responds with each stage the project should support.
    # @return [Array<Symbol>] An array of each stage name as a symbol.
    may_implement :allowed_stages
  end
end
