# frozen_string_literal: true

require 'litany/resource'

module Litany
  class BaseInstance < Resource; end
  class AutoScalingLaunchConfiguration < BaseInstance; end
  class ApplicationLoadBalancerListener < Resource; end
  class ApplicationLoadBalancerListenerRule < Resource; end
  class ApplicationLoadBalancerTargetGroup < Resource; end
  class BeanstalkEnvironment < Resource; end
  class Certificate < Resource; end
  class CloudWatchAlarm < Resource; end
  class CloudWatchLogGroup < Resource; end
  class CloudWatchLogMetricFilter < Resource; end
  class DNSAlias < Resource; end
  class DNSHealthCheck < Resource; end
  class DNSRecord < Resource; end
  class ECRRepository < Resource; end
  class ECSCluster < Resource; end
  class ECSTaskDefinition < Resource; end
  class EFSMountTarget < Resource; end
  class ElastiCacheSubnetGroup < Resource; end
  class ElasticLoadBalancer < Resource; end
  class ElasticsearchDomain < Resource; end
  class EventsRule < Resource; end
  class IAMRole < Resource; end
  class Instance < BaseInstance; end
  class InstanceProfile < Resource; end
  class InstanceProfileRole < Resource; end
  class KinesisStream < Resource; end
  class KMSKey < Resource; end
  class LambdaFunction < Resource; end
  class LambdaPermission < Resource; end
  class NetworkLoadBalancer < Resource; end
  class NetworkLoadBalancerListener < Resource; end
  class NetworkLoadBalancerTargetGroup < Resource; end
  class RDSClusterParameterGroup < Resource; end
  class RDSOptionsGroup < Resource; end
  class RDSInstanceParameterGroup < Resource; end
  class RDSSubnetGroup < Resource; end
  class RedshiftParameterGroup < Resource; end
  class RedshiftSubnetGroup < Resource; end
  class Route53Zone < Resource; end
  class S3Bucket < Resource; end
  class S3BucketPolicy < Resource; end
  class Subnet < Resource; end
  class SecretsManagerSecret < Resource; end
  class SecretsManagerSecretAttachment < Resource; end
  class SecurityGroup < Resource; end
  class SecurityGroupIngress < Resource; end
  class SNSTopic < Resource; end
  class SQSQueue < Resource; end
  class SQSQueuePolicy < Resource; end
  class SubnetRouteTableAssociation < Resource; end
  class Volume < Resource; end
  class VPC < Resource; end
  class VPCEndpoint < Resource; end
  class VPCEndpointService < Resource; end
  class VPCEndpointServicePermissions < Resource; end
  class VPCInternetGatewayAttachment < Resource; end
  class VPCPeeringConnection < Resource; end
  class VPCVPNGatewayAttachment < Resource; end
  class VPNGateway < Resource; end
  class VPNGatewayRoutePropagation < Resource; end
end
