# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class BeanstalkApplication < Resource

    cfn_type 'AWS::ElasticBeanstalk::Application'
    parent_resource :service

    property :application_name, nil, [nil, String, Symbol], inherited: true
    property :description, '', String, inherited: true

    property :max_version_count, 5, 1..1000, inherited: true

    resource_reference IAMRole, :service_role, inherited: true

    resource_collection BeanstalkEnvironment, :eb_environment, required: false

    def depends_on
      [service_role.resource_name]
    end

    def properties
      {
        ApplicationName: set_application_name? ? application_name : name,
        Description: description,
        ResourceLifecycleConfig: {
          ServiceRole: ref(service_role, 'Arn'),
          VersionLifecycleConfig: {
            MaxCountRule: {
              DeleteSourceFromS3: false,
              Enabled: true,
              MaxCount: max_version_count
            }
          }
        }
      }
    end
  end
end
