# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class CloudWatchLogMetricFilter < Resource
    cfn_type 'AWS::Logs::MetricFilter'
    parent_resource :log_group

    child_resource CloudWatchAlarm, :alarm, automatic: :on_access

    property :metric, nil, String
    property :namespace, nil, String
    property :pattern, nil, String

    def properties
      {
        FilterPattern: pattern,
        LogGroupName: ref(log_group),
        MetricTransformations: [
          {
            MetricValue: 1,
            MetricNamespace: namespace,
            MetricName: metric
          }
        ]
      }
    end
  end
end
