# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class ElasticIp < Resource
    cfn_type 'AWS::EC2::EIP'
    parent_resource :instance

    def properties
      {
        InstanceId: ref(instance),
        Domain: 'vpc'
      }
    end
  end
end