# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class ECSCluster < Resource
    cfn_type 'AWS::ECS::Cluster'
    parent_resource :service

    output
    output :Arn

    def properties
      {
        ClusterName: name
      }
    end
  end
end
