# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class EFSMountTarget < Resource
    cfn_type 'AWS::EFS::MountTarget'
    parent_resource :filesystem

    resource_reference SecurityGroup, :access_sg
    resource_reference Subnet, :subnet

    def properties
      # Not implementing: IpAddress
      {
        FileSystemId: ref(filesystem),
        SecurityGroups: [ref(access_sg)],
        SubnetId: ref(subnet)
      }
    end
  end
end
