# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class ElastiCacheSubnetGroup < Resource
    cfn_type 'AWS::ElastiCache::SubnetGroup'
    parent_resource :elasticache

    property :description, nil, [String, nil]

    def properties
      props = {
        Description: description || "Subnet group for #{elasticache.resource_name}.",
        SubnetIds: ref(elasticache.vpc.subnets)
      }
    end
  end
end
