# frozen_string_literal: true

require 'litany/resource'
require 'litany/mixins'
module Litany
  class InstanceProfile < Resource
    cfn_type 'AWS::IAM::InstanceProfile'
    parent_resource :service

    child_resource InstanceProfileRole, :role

    property :path, '/', [String]

    def allow(actions, on_resource=nil)
      role do
        next_policy do
          next_statement do
            actions actions
            on_resource on_resource unless on_resource.nil?
          end
        end
      end
    end

    def properties
      {
        Path: path,
        Roles: [ref(role)],
        InstanceProfileName: "#{output_name}-#{active_environment.pretty_region}"
      }
    end
  end
end
